# Likepois_random.R
# Plot likelihood for Poisson data vs. lambda

# Load necessary libraries
library(ggplot2)

# Define likelihood function
likefn <- function(x,y){
return(prod(dpois(y,x)))
}

# Generate n random Poisson observations
n <- 3
lambda_true <- 6
y <- rpois(n,lambda_true)

# Minimum, maximum, and step values of lambda
lmin <- 0.1
lmax <- 15
lstep <- 0.1

# Find x (lambda) values for the plot
lambda <- seq(lmin,lmax,lstep)

# Find likelihood as a function of x (lambda)
likelihood <- sapply(lambda,likefn,y)

# Make data frame for ggplot2
likedata <- as.data.frame(cbind(lambda,likelihood))

# Print y data
y

# Print likelihood data
likedata

# Plot the values
ggplot(likedata,aes(lambda,likelihood))+
geom_line(color="red",size=1)+
ggtitle("Poisson likelihood function")
